/* GCompris - Data.qml
 *
 * SPDX-FileCopyrightText: 2020 Shubham Mishra <shivam828787@gmail.com>
 *
 * Authors:
 *   Shubham Mishra <shivam828787@gmail.com>
 *
 *   SPDX-License-Identifier: GPL-3.0-or-later
 */
import core 1.0

Data {
    objective: qsTr("Medium grids using symbols.")
    difficulty: 4

    property var symbols: [
        {"imgName": "circle.svg", "text": 'A'},
        {"imgName": "rectangle.svg", "text": 'B'},
        {"imgName": "rhombus.svg", "text": 'C'},
        {"imgName": "star.svg", "text": 'D'},
        {"imgName": "triangle.svg", "text": 'E'}
    ]

    data: [
        {
            "symbols": symbols,
            "data": [
                [
                    ['.','B','C','D'],
                    ['D','C','.','A'],
                    ['.','D','A','B'],
                    ['B','A','.','C']
                ],
                [
                    ['A','.','.','D'],
                    ['D','C','B','.'],
                    ['C','D','A','.'],
                    ['.','.','D','C']
                ],
                [
                    ['.','B','.','.'],
                    ['.','C','B','A'],
                    ['C','D','A','.'],
                    ['.','.','D','.']
                ],
                [
                    ['.','B','A','.'],
                    ['D','.','B','C'],
                    ['A','C','.','B'],
                    ['.','D','C','.']
                ],
                [
                    ['.','.','.','.'],
                    ['D','A','B','C'],
                    ['A','C','D','B'],
                    ['.','.','.','.']
                ],
            ]
        },
        {
            "symbols": symbols,
            "data": [
                [
                    ['.','.','.','.'],
                    ['D','A','B','.'],
                    ['C','.','A','B'],
                    ['.','.','.','D']
                ],
                [
                    ['A','B','C','D'],
                    ['.','.','.','.'],
                    ['.','.','.','.'],
                    ['B','C','D','A']
                ],
                [
                    ['.','.','A','D'],
                    ['D','.','.','C'],
                    ['A','.','.','B'],
                    ['B','D','.','.']
                ],
                [
                    ['.','.','A','.'],
                    ['D','A','B','.'],
                    ['.','C','D','B'],
                    ['.','D','.','.']
                ],
                [
                    ['C','B','.','D'],
                    ['.','.','.','C'],
                    ['A','.','.','.'],
                    ['B','.','C','A']
                ],
            ]
        },
        {
            "symbols": symbols,
            "data": [
                [
                    ['C','.','.','D'],
                    ['.','.','B','.'],
                    ['A','.','.','.'],
                    ['.','.','D','.']
                ],
                [
                    ['.','B','.','A'],
                    ['.','.','B','.'],
                    ['C','.','D','.'],
                    ['.','.','.','C']
                ],
                [
                    ['A','.','B','.'],
                    ['.','C','.','A'],
                    ['.','.','.','D'],
                    ['D','.','C','.']
                ],
                [
                    ['.','A','.','.'],
                    ['C','.','A','B'],
                    ['.','.','C','.'],
                    ['D','.','.','A']
                ],
                [
                    ['C','.','.','D'],
                    ['B','.','A','.'],
                    ['.','B','.','A'],
                    ['.','.','.','.']
                ],
                [
                    ['.','A','C','.'],
                    ['.','.','.','D'],
                    ['C','.','.','A'],
                    ['.','B','.','.']
                ],
                [
                    ['.','C','.','D'],
                    ['B','.','.','.'],
                    ['.','.','.','.'],
                    ['C','A','.','B']
                ],
                [
                    ['B','.','.','C'],
                    ['.','A','.','.'],
                    ['.','.','D','.'],
                    ['.','B','.','.']
                ]
            ]
        }
    ]
}
