/* GCompris
 *
 * SPDX-FileCopyrightText: 2015 Ayush Agrawal <ayushagrawal288@gmail.com>
 *
 * Authors:
 *   Bruno Coudoin <bruno.coudoin@gcompris.net> (GTK+ version)
 *   Ayush Agrawal <ayushagrawal288@gmail.com> (Qt Quick port)
 *
 *   SPDX-License-Identifier: GPL-3.0-or-later
 */
import QtQuick

QtObject {
    property string backgroundImage: "qrc:/gcompris/src/activities/explore_monuments/resource/usa/usa.svg"
    property var tab: [
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Cabrillo"),
            "text": qsTr("Situated on Point Loma in San Diego, California, Cabrillo National Monument commemorates the first European to land on the West Coast of the United States, Juan Rodriguez Cabrillo. Portuguese by birth, Cabrillo carried the Spanish flag in his conquests of the New World. He arrived at San Diego Bay in September 1542, three months after departing from Barra de Navidad on the west coast of Mexico."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/cabrillo.webp",
            "text2": qsTr("Cabrillo"),
            "x": "0.182",
            "y": "0.586",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Canyon de Chelly"),
            "text": qsTr("The stoic red ruins of Canyon de Chelly in northeastern Arizona are at once part of the National Park Service and the Navajo Nation, having been established as a national monument in 1931. A number of important early Native American sites are preserved in the nearly 84000 acres of parkland, and Canyon de Chelly also offers an array of Southwestern geological formations, including Spider Rock, an 800-foot-tall sandstone spire that rises eerily from the bottom of the canyon floor."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/canyondeChelly.webp",
            "text2": qsTr("Canyon de Chelly"),
            "x": "0.277",
            "y": "0.569",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Castillo de San Marcos"),
            "text": qsTr("Set on more than 20 acres in St. Augustine, Florida, the Castillo de San Marcos was completed as the city's defensive fort in 1695, when Florida was still a Spanish territory. Constructed out of the rare coquina limestone, the star-shaped Castillo also is the oldest masonry fort in the country."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/castillodeSanMarcos.webp",
            "text2": qsTr("Castillo de San Marcos"),
            "x": "0.759",
            "y": "0.668",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Castle Clinton"),
            "text": qsTr("This round, sandstone fort sitting at the bottom of Manhattan Island predates Ellis Island by about 50 years as the first U.S. immigration checkpoint. Castle Clinton (nps.gov/cacl) was originally built as a fort to protect New York from a British invasion during the War of 1812, and was dedicated as a national monument in 1946."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/castleClinton.webp",
            "text2": qsTr("Castle Clinton"),
            "x": "0.841",
            "y": "0.390",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("George Washington Birthplace"),
            "text": qsTr("The George Washington Birthplace National Monument is in Westmoreland County, Virginia, United States. Originally settled by John Washington, George Washington's great-grandfather, George Washington was born here on February 22, 1732. He lived here until age three, returning later as a teenager."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/georgeWashingtonBirthplace.webp",
            "text2": qsTr("George Washington Birthplace"),
            "x": "0.836",
            "y": "0.532",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Lincoln Memorial"),
            "text": qsTr("Built in white stone with 36 iconic columns, The Lincoln Memorial is one of the most recognized structures in the United States. The memorial is at the west end of the National Mall, in West Potomac Park, and is an example in Neoclassical architecture. It features a solitary, 19-foot-tall statue of Abraham Lincoln sitting in contemplation, which is flanked on both side chambers with inscriptions of Lincoln’s Second Inaugural Address and arguably his most famous speech, the Gettysburg Address."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/lincolnMemorial.webp",
            "text2": qsTr("Lincoln Memorial"),
            "x": "0.791",
            "y": "0.456",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Mount Rushmore"),
            "text": qsTr("Mt. Rushmore stands as a shrine of democracy, a monument and memorial to George Washington, this country's birth, growth and ideals. Mount Rushmore symbolizes the greatness of this nation through the greatness of its leaders. The epic sculpture of Mount Rushmore depicts the faces of four exalted American presidents that symbolize this nation's rich history, rugged determination and lasting achievements."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/mountRushmore.webp",
            "text2": qsTr("Mount Rushmore"),
            "x": "0.492",
            "y": "0.399",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Navajo"),
            "text": qsTr("Navajo National Monument is a National Monument located within the northwest portion of the Navajo Nation territory in northern Arizona, which was established to preserve three-well preserved cliff dwellings of the Ancestral Puebloan People: Keet Seel (Kitsʼiil), Betatakin (Bitátʼahkin), and Inscription House (Tsʼah Biiʼ Kin). The monument is high on the Shonto plateau, overlooking the Tsegi Canyon system, west of Kayenta, Arizona. It features a visitor center with a museum, two short self-guided mesa top trails, two small campgrounds, and a picnic area. Rangers guide visitors on free tours of the Keet Seel and Betatakin cliff dwellings. The Inscription House site, further west, is currently closed to public access."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/navajo.webp",
            "text2": qsTr("Navajo"),
            "x": "0.300",
            "y": "0.498",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Statue of Liberty"),
            "text": qsTr("Perhaps the best-known monument and symbol of the United States is the Statue of Liberty, which sits on its own tiny island in New York City. The statue was a gift from the people of France and was dedicated in October 1886."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/statueofLiberty.webp",
            "text2": qsTr("Statue of Liberty"),
            "x": "0.860",
            "y": "0.309",
            "height": "0.07",
            "width": "0.07"
        },
        {
            "image": "qrc:/gcompris/src/activities/explore_monuments/resource/key.svg",
            "title": qsTr("Fort Sumter"),
            "text": qsTr("Originally built as a defensive structure following the War of 1812, it was at this oceanfront fortification in Charleston Harbor, South Carolina, that the first shots of the Civil War were fired. Inside Fort Sumter, a number of exhibits offer perspectives on U.S. history, particularly the divisions between North and South that eventually resulted in the war."),
            "image2": "qrc:/gcompris/src/activities/explore_monuments/resource/usa/fortSumter.webp",
            "text2": qsTr("Fort Sumter"),
            "x": "0.769",
            "y": "0.589",
            "height": "0.07",
            "width": "0.07"
        },
    ]

    property var instructions: [
        {
            "text": qsTr("Monuments of US")
        },
        {
            "text": qsTr("Click on the location of the given monument.")
        }
    ]
}
